
#define TRUE	1
#define FALSE	0

#define MAX(a,b)	(a>=b)?a:b
#define MIN(a,b)	(a<=b)?a:b

#define M(f)		fprintf(stderr,f); fflush(stderr);
#define M1(f,a)		fprintf(stderr,f,a); fflush(stderr);
#define M2(f,a,b)	fprintf(stderr,f,a,b); fflush(stderr);
#define M3(f,a,b,c)	fprintf(stderr,f,a,b,c); fflush(stderr);
#define M4(f,a,b,c,d)	fprintf(stderr,f,a,b,c,d); fflush(stderr);
#define M5(f,a,b,c,d,e)	fprintf(stderr,f,a,b,c,d,e); fflush(stderr);
#define M6(f,a,b,c,d,e,g) fprintf(stderr,f,a,b,c,d,e,g); fflush(stderr);

/************************************************************************
 * NAME:	BucketDiv()
 *
 * DESCR:	This cool little function is used when doing math that
 *		needs to shift on zero.  In other words, for example,
 *		when deciding how many sectors are necessary to store a
 *		certain number of bytes, regular division doesn't work.
 *		You need to account for 256 bytes fitting within a sector
 *		that is 256 bytes long, as well as needing a whole 256-
 *		byte sector to store 255 bytes.
 *
 *		So the math is simply that you do the straight division,
 *		and add 1 to account for having an extra "bucket" for the
 *		left over bytes.  However, if the bytes fit exactly into
 *		a number of buckets, that extra isn't added because the
 *		division caused the extra bucket to be added.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
#define BucketDiv(count,divisor)  ((count)/(divisor)+(((count)%(divisor))?1:0))

/************************************************************************
 * NAME:	EVEN_MULTIPLE()
 *
 * DESCR:	Returns TRUE if the given dividend can be divided by
 *		divisor evenly.
 *			EVEN_MULTIPLE(10,2) --> TRUE
 *			EVEN_MULTIPLE(10,3) --> FALSE
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
#define EVEN_MULTIPLE(dividend,divisor)	((dividend - (divisor * (dividend / divisor)))==0)
